/*
 * Decompiled with CFR 0.152.
 */
package net.keithpray;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.keithpray.SalesFun;

public class TestSalesFun
extends Application {
    public void start(Stage primaryStage) throws Exception {
        final GridPane gridPane = new GridPane();
        gridPane.setAlignment(Pos.CENTER);
        Label amountLabel = new Label("Amount: ");
        final TextField amountTextField = new TextField();
        Label discountLabel = new Label("Discount: ");
        final TextField discountTextField = new TextField();
        Label taxLabel = new Label("Tax: ");
        final TextField taxTextField = new TextField();
        final Label outputLabel = new Label(SalesFun.reportSalesTotal(0.0, 0.0, 0.0));
        Button calculateSalesTotalButton = new Button("Calculate Sales Total");
        calculateSalesTotalButton.setDefaultButton(true);
        calculateSalesTotalButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                double amountDouble = Double.NaN;
                double discountDouble = Double.NaN;
                double taxDouble = Double.NaN;
                try {
                    amountDouble = Double.parseDouble(amountTextField.getText());
                    discountDouble = Double.parseDouble(discountTextField.getText());
                    taxDouble = Double.parseDouble(taxTextField.getText());
                }
                catch (NumberFormatException e) {
                    TestSalesFun.this.showAlert(Alert.AlertType.WARNING, gridPane.getScene().getWindow(), "That was naughty", "Please enter numbers");
                }
                outputLabel.setText(SalesFun.reportSalesTotal(amountDouble, discountDouble, taxDouble));
            }
        });
        gridPane.add((Node)amountLabel, 0, 0);
        gridPane.add((Node)amountTextField, 1, 0);
        gridPane.add((Node)discountLabel, 0, 1);
        gridPane.add((Node)discountTextField, 1, 1);
        gridPane.add((Node)taxLabel, 0, 2);
        gridPane.add((Node)taxTextField, 1, 2);
        gridPane.add((Node)calculateSalesTotalButton, 1, 3);
        gridPane.add((Node)outputLabel, 1, 4);
        primaryStage.setScene(new Scene((Parent)gridPane, 300.0, 250.0));
        primaryStage.setTitle("Sales Fun");
        primaryStage.show();
    }

    private void showAlert(Alert.AlertType alertType, Window owner, String title, String message) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.initOwner(owner);
        alert.show();
    }

    public static void main(String[] args) {
        TestSalesFun.launch((String[])args);
    }
}

